/*
 * Decompiled with CFR 0.152.
 */
package com.bdlington.Catalyst.modules;

import com.bdlington.Catalyst.CatalystAddon;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2338;
import net.minecraft.class_2708;

public class RTPer
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgWebhook;
    private final Setting<Integer> targetX;
    private final Setting<Integer> targetZ;
    private final Setting<String> distance;
    private final Setting<RTPRegion> rtpRegion;
    private final Setting<Boolean> disconnectOnReach;
    private final Setting<Integer> rtpDelay;
    private final Setting<Boolean> webhookEnabled;
    private final Setting<String> webhookUrl;
    private int tickTimer;
    private boolean isRtping;
    private int rtpAttempts;
    private class_2338 lastRtpPos;
    private double lastReportedDistance;
    private int targetDistanceBlocks;

    public RTPer() {
        super(CatalystAddon.CATEGORY, "RTPer", "RTP to specific coordinates.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgWebhook = this.settings.createGroup("Webhook");
        this.targetX = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("target-x")).description("Target X coordinate.")).defaultValue((Object)0)).build());
        this.targetZ = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("target-z")).description("Target Z coordinate.")).defaultValue((Object)0)).build());
        this.distance = this.sgGeneral.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("distance")).description("Distance to get within (supports k/m, e.g., 10k = 10000, 1.5m = 1500000).")).defaultValue((Object)"1000")).build());
        this.rtpRegion = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("rtp-region")).description("RTP region to use.")).defaultValue((Object)RTPRegion.WEST)).build());
        this.disconnectOnReach = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("disconnect-on-reach")).description("Disconnect when reaching the target coordinates.")).defaultValue((Object)true)).build());
        this.rtpDelay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("rtp-delay")).description("Delay between RTP attempts in seconds.")).defaultValue((Object)15)).min(11).max(20).sliderMin(11).sliderMax(20).build());
        this.webhookEnabled = this.sgWebhook.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("webhook-enabled")).description("Enable webhook notifications.")).defaultValue((Object)false)).build());
        this.webhookUrl = this.sgWebhook.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("webhook-url")).description("Discord webhook URL.")).defaultValue((Object)"")).visible(() -> this.webhookEnabled.get())).build());
        this.tickTimer = 0;
        this.isRtping = false;
        this.rtpAttempts = 0;
        this.lastRtpPos = null;
        this.lastReportedDistance = -1.0;
        this.targetDistanceBlocks = 1000;
    }

    public void onActivate() {
        this.tickTimer = 0;
        this.isRtping = false;
        this.rtpAttempts = 0;
        this.lastRtpPos = null;
        this.lastReportedDistance = -1.0;
        this.targetDistanceBlocks = this.parseDistance();
        if (this.mc.field_1724 == null) {
            return;
        }
        double currentDist = this.getCurrentDistance();
        this.info("RTPer started - target: (%d, %d)", new Object[]{this.targetX.get(), this.targetZ.get()});
        this.info("Distance: %s -> %d blocks", new Object[]{this.distance.get(), this.targetDistanceBlocks});
        this.info("Current: %.1f blocks away", new Object[]{currentDist});
        if (currentDist <= (double)this.targetDistanceBlocks) {
            this.info("Already close enough!", new Object[0]);
            this.toggle();
        }
    }

    public void onDeactivate() {
        this.info("Stopped after %d attempts", new Object[]{this.rtpAttempts});
        this.isRtping = false;
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        double currentDistance = this.getCurrentDistance();
        if (this.isNearTarget(currentDistance)) {
            this.info("Done! %.1f blocks away (target: %d)", new Object[]{currentDistance, this.targetDistanceBlocks});
            if (((Boolean)this.webhookEnabled.get()).booleanValue()) {
                this.sendWebhook("Target Reached!", String.format("Got to %d, %d\\nDistance: %.1f/%d blocks\\nAttempts: %d", this.targetX.get(), this.targetZ.get(), currentDistance, this.targetDistanceBlocks, this.rtpAttempts), 65280);
            }
            if (((Boolean)this.disconnectOnReach.get()).booleanValue()) {
                this.info("Disconnecting...", new Object[0]);
                if (this.mc.field_1687 != null) {
                    this.mc.field_1687.method_8525();
                }
            }
            this.toggle();
            return;
        }
        if (this.tickTimer % 100 == 0 && Math.abs(currentDistance - this.lastReportedDistance) > 100.0) {
            this.info("Distance: %.1f blocks", new Object[]{currentDistance});
            this.lastReportedDistance = currentDistance;
        }
        ++this.tickTimer;
        if (this.tickTimer >= (Integer)this.rtpDelay.get() * 20 && !this.isRtping) {
            this.performRTP();
            this.tickTimer = 0;
        }
    }

    @EventHandler
    private void onPacketReceive(PacketEvent.Receive event) {
        if (event.packet instanceof class_2708 && this.mc.field_1724 != null) {
            this.isRtping = false;
            class_2338 currentPos = this.mc.field_1724.method_24515();
            if (this.lastRtpPos == null || !currentPos.equals((Object)this.lastRtpPos)) {
                ++this.rtpAttempts;
                this.lastRtpPos = currentPos;
                double distance = this.getCurrentDistance();
                this.info("RTP %d done - pos: (%d, %d, %d) dist: %.1f", new Object[]{this.rtpAttempts, currentPos.method_10263(), currentPos.method_10264(), currentPos.method_10260(), distance});
                if (this.lastReportedDistance > 0.0) {
                    double diff = this.lastReportedDistance - distance;
                    if (diff > 0.0) {
                        this.info("Better by %.1f blocks", new Object[]{diff});
                    } else if (diff < -1000.0) {
                        this.info("Worse by %.1f blocks", new Object[]{Math.abs(diff)});
                    }
                }
                this.lastReportedDistance = distance;
            }
        }
    }

    private void performRTP() {
        if (this.mc.field_1724 == null) {
            return;
        }
        this.isRtping = true;
        ChatUtils.sendPlayerMsg((String)("/rtp " + ((RTPRegion)((Object)this.rtpRegion.get())).getCommandPart()));
        double currentDistance = this.getCurrentDistance();
        this.info("Attempting RTP (%s) - current: %.1f blocks", new Object[]{((RTPRegion)((Object)this.rtpRegion.get())).getCommandPart(), currentDistance});
    }

    private boolean isNearTarget() {
        return this.isNearTarget(this.getCurrentDistance());
    }

    private boolean isNearTarget(double currentDistance) {
        return currentDistance <= (double)this.targetDistanceBlocks;
    }

    private double getCurrentDistance() {
        if (this.mc.field_1724 == null) {
            return Double.MAX_VALUE;
        }
        class_2338 pos = this.mc.field_1724.method_24515();
        double dx = pos.method_10263() - (Integer)this.targetX.get();
        double dz = pos.method_10260() - (Integer)this.targetZ.get();
        return Math.sqrt(dx * dx + dz * dz);
    }

    private int parseDistance() {
        String dist = ((String)this.distance.get()).toLowerCase().trim();
        if (dist.isEmpty()) {
            this.error("Empty distance, using 1000", new Object[0]);
            return 1000;
        }
        try {
            if (dist.endsWith("k")) {
                String num = dist.substring(0, dist.length() - 1).trim();
                if (num.isEmpty()) {
                    this.error("Bad format: '%s', using 1000", new Object[]{dist});
                    return 1000;
                }
                double val = Double.parseDouble(num);
                return (int)(val * 1000.0);
            }
            if (dist.endsWith("m")) {
                String num = dist.substring(0, dist.length() - 1).trim();
                if (num.isEmpty()) {
                    this.error("Bad format: '%s', using 1000", new Object[]{dist});
                    return 1000;
                }
                double val = Double.parseDouble(num);
                return (int)(val * 1000000.0);
            }
            return Integer.parseInt(dist);
        }
        catch (NumberFormatException e) {
            this.error("Can't parse '%s': %s, using 1000", new Object[]{dist, e.getMessage()});
            return 1000;
        }
    }

    private void sendWebhook(String title, String description, int color) {
        if (!((Boolean)this.webhookEnabled.get()).booleanValue() || ((String)this.webhookUrl.get()).isEmpty()) {
            return;
        }
        new Thread(() -> {
            try {
                String timestamp = LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                String json = String.format("{\n    \"username\": \"Catalyst Webhook\",\n    \"avatar_url\": \"https://i.imgur.com/OL2y1cr.png\",\n    \"embeds\": [{\n        \"title\": \"RTPer Alert\",\n        \"description\": \"%s\",\n        \"color\": %d,\n        \"footer\": {\n            \"text\": \"Sent by Catalyst\"\n        },\n        \"timestamp\": \"%sZ\",\n        \"fields\": [{\n            \"name\": \"Status\",\n            \"value\": \"%s\",\n            \"inline\": true\n        }]\n    }]\n}", description.replace("\\n", "\\n"), color, timestamp, title);
                HttpClient client = HttpClient.newHttpClient();
                HttpRequest req = HttpRequest.newBuilder().uri(URI.create((String)this.webhookUrl.get())).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(json)).build();
                HttpResponse<String> res = client.send(req, HttpResponse.BodyHandlers.ofString());
                if (res.statusCode() == 204) {
                    this.info("Webhook sent", new Object[0]);
                } else {
                    this.error("Webhook failed: %d", new Object[]{res.statusCode()});
                }
            }
            catch (IOException | InterruptedException e) {
                this.error("Webhook error: %s", new Object[]{e.getMessage()});
            }
        }).start();
    }

    public static enum RTPRegion {
        ASIA("asia"),
        EAST("east"),
        EU_CENTRAL("eu central"),
        EU_WEST("eu west"),
        OCEANIA("oceania"),
        WEST("west");

        private final String commandPart;

        private RTPRegion(String commandPart) {
            this.commandPart = commandPart;
        }

        public String getCommandPart() {
            return this.commandPart;
        }
    }
}

